function [rmsTraction, netMoment, strainEnergy, orientation] = traction_boussinesq_constrained2(x,y,ux,uy,pois,young,xrub,yrub,PixelSize,CalcRot,pathname,k); 
%   Calculates the constrained tractions using FTTC
%    
%   Xavier Trepat 2007
%	Iva Marija Tolic-Norrelykke 03-22-01

%  CENTER DISPLACEMENTS, PIXELS TO MICRONS, SPACING
%{
%put even displacements into column
DispX  	= 	mat2vertcol(ux);
DispY  	= 	mat2vertcol(uy); 
xorig 	= 	mat2vertcol(x);
yorig 	= 	mat2vertcol(y); 

xv  = (xorig - mean(xorig));
yv  = (yorig - mean(yorig));
uxv = (DispX);
uyv = (DispY);
   
%}
%====================================================================================
%  CONSTANTS

a1   = (1.0 + pois) * (1.0 - pois) / (pi * young);
b1   = (1.0 + pois) * pois / (pi * young);
c1   = (1.0 + pois) * pois / (pi * young);

%====================================================================================
%  DEFINITIONS

xvorig = x;
yvorig = y;

spacing = y(2) - y(1);

%====================================================================================
%  N, RESHAPE DISPLACEMENTS

%======================================================
% make sure there is an even number of rows and columns
%below part not used in original fttc_v6_automated_rk.m that works!
if(mod(length(ux),2)),
    N = length(ux)-1;
else
    N   = length(ux);
end

x  = x(1:N,1:N);
y  = y(1:N,1:N);
ux  = ux(1:N,1:N);
uy  = uy(1:N,1:N);
%======================================================
% Prepare for zero padding.
N = 2*N;
%N = sqrt(length(xv)) * 2;%originally in fttc_v6_automated_rk.m that works!

iteration = 100; 
the_same  = 1e-6;

ux    = ux * 2 * pi / (N * spacing);
uy    = uy * 2 * pi / (N * spacing);

[x,y]  = meshgrid([(min2(x) - spacing*N/4 : spacing : min2(x)), x(1,2:size(x,2)-1),...
        (max2(x) : spacing : max2(x) + spacing*N/4)],...
    [(min2(y) - spacing*N/4 : spacing : min2(y)), y(2:size(y,1)-1,1)',...
        (max2(y) : spacing : max2(y) + spacing*N/4)]);
ux = [zeros(N/4,N); zeros(N/2,N/4), ux, zeros(N/2,N/4); zeros(N/4,N)];   
uy = [zeros(N/4,N); zeros(N/2,N/4), uy, zeros(N/2,N/4); zeros(N/4,N)];   

xv     =  reshape(x,N^2,1);
yv     =  reshape(y,N^2,1);
uxv    =  reshape(ux,N^2,1);
uyv    =  reshape(uy,N^2,1);

%====================================================================================
%cell boundary

%used in fttc_v6_automated_rk.m
%either xvorig, yvorig or x or y
%{
xorig 	= 	mat2vertcol(xvorig);
yorig 	= 	mat2vertcol(yvorig); 
 
xrub = (xrub - mean(xorig))*PixelSize;
yrub = (yrub - mean(yorig))*PixelSize;
%}

%xrub = (xrub - 1*mean(xvorig)) * PixelSize;
%yrub = (yrub - 1*mean(yvorig)) * PixelSize;

area_cell = polyarea(xrub,yrub);

cell1 = find(xv >= min2(xvorig) & xv <= max2(xvorig) &...
    yv >= min2(yvorig) & yv <= max2(yvorig));
cell  = inpolygon(xv(cell1),yv(cell1),xrub,yrub);
cell  = cell1(find(cell > 0));       % POINTS IN THE INTERIOR OF THE CELL



%====================================================================================
%  kx, ky, AND k_abs 

clear mala*;
for i = 1:(N/2)
    malax(i,:) = 0:((N/2)-1);                     
    malay(i,1:(N/2)) = (N/2)-i;                   
end;

kx = [ malax  malax-(N/2);  malax  malax-(N/2) ];
ky = [ malay-(N/2)  malay-(N/2);  malay  malay ];
ky = flipud(ky);
kx(:,(N/2+1)) =  kx(:,(N/2+1));                     
ky((N/2+1),:) =  ky((N/2+1),:);

k_abs = sqrt(kx.^2 + ky.^2);

%====================================================================================
%  ALPHA

alpha = atan2(ky,kx);
if kx(1,1) == 0 & ky(1,1) == 0,
    alpha(1,1) = 1.57080;
end;

%====================================================================================
%  C AND D

Cx = ((k_abs * young) / (2 * (1 - pois^2))) .* (1 - pois + pois .* (cos(alpha)).^2);
Cy = ((k_abs * young) / (2 * (1 - pois^2))) .* (1 - pois + pois .* (sin(alpha)).^2);
D  = ((k_abs * young) / (2 * (1 - pois^2))) .* (pois .* sin(alpha) .* cos(alpha));

D(:,(N/2+1)) = zeros(N,1);
D((N/2+1),:) = zeros(1,N);

%====================================================================================
%  A AND B

if k_abs(1,1) == 0,
    k_abs(1,1) = 1;
end;

Ax = a1 * ( 2 * pi ./ k_abs) + b1 * (2 * pi ./ k_abs) .* (sin(alpha)).^2;
Ay = a1 * ( 2 * pi ./ k_abs) + b1 * (2 * pi ./ k_abs) .* (cos(alpha)).^2;
B  = c1 * (-2 * pi ./ k_abs) .* sin(alpha) .* cos(alpha);

B(:,(N/2+1)) = zeros(N,1);
B((N/2+1),:) = zeros(1,N);

%====================================================================================
%  CALCULATE THE FIRST TRACTIONS

Dx = fft2(ux);
Dy = fft2(uy);

Tx = Cx .* Dx  +  D  .* Dy;
Ty = D  .* Dx  +  Cy .* Dy;

tx = real(ifft2(Tx));
ty = real(ifft2(Ty));

%====================================================================================
%  ITERATIONS

step = 1;
are_the_same = 0;

while step <= iteration & are_the_same == 0,
    
    %====================================================================================
    %  FORM NEW (MIXED) TRACTION MATRIX
    
    tx2 = zeros(N,N);
    ty2 = zeros(N,N);
    
    tx2(cell) = tx(cell);   
    ty2(cell) = ty(cell);   
    
    %====================================================================================
    %  CALCULATE THE INDUCED DISPLACEMENTS
    
    Tx = fft2(tx2);       
    Ty = fft2(ty2);      
    
    Dx = Ax .* Tx  +  B  .* Ty;  
    Dy = B  .* Tx  +  Ay .* Ty;  
    
    dx2 = real(ifft2(Dx));
    dy2 = real(ifft2(Dy));
    
    %====================================================================================
    %  FORM NEW (MIXED) DISPLACEMENT MATRIX
    
    dx3 = dx2;                   
    dy3 = dy2;   
    
    dx3(cell) = ux(cell);  
    dy3(cell) = uy(cell);
    
    %====================================================================================
    %  CALCULATE THE TRACTIONS
    
    Dx = fft2(dx3);
    Dy = fft2(dy3);
    
    Tx = Cx .* Dx  +  D  .* Dy;
    Ty = D  .* Dx  +  Cy .* Dy;
    
    tx3 = real(ifft2(Tx));
    ty3 = real(ifft2(Ty));
    
    %====================================================================================
    %  FORM NEW (MIXED) TRACTION MATRIX
    
    tx = 0.5 * tx3 + 0.5 * tx2;
    ty = 0.5 * ty3 + 0.5 * ty2;
    
    if spacing <= 4,
        tx = 0.2 * tx3 + 0.8 * tx2;
        ty = 0.2 * ty3 + 0.8 * ty2;
    end;
    
    maxt(step) = max(max(tx3.^2 + ty3.^2));
    
    %====================================================================================
    % CHECK IF THE TRACTIONS HAVE CONVERGED
    
    if step > 3,
        if abs(maxt(step) - maxt(step-1)) <= the_same * maxt(step),
            are_the_same = 1; 
        end;
    end;
    step = step + 1;
end; %(iteration)
if are_the_same ~= 1, disp(' Convergence was not reached!'); end;

%====================================================================================
%  SUBTRACT mean(t(cell)), BACK TO ORIGINAL ux 

tx = real(tx3); 
ty = real(ty3);
tx(cell) = tx(cell) - mean(tx(cell));
ty(cell) = ty(cell) - mean(ty(cell));

ux = ux * N * spacing / (2 * pi);
uy = uy * N * spacing / (2 * pi);

%====================================================================================
%  RMS TRACTION, THETA, A_CUTS, TRACE, U

rmst_iterative = sqrt(mean2(tx(cell).^2 + ty(cell).^2));

tot_force   = sum(sum(sqrt(tx(cell).^2 + ty(cell).^2)))*spacing^2;

%=========================================================
%all below originally multiplied by * 1e-6
Dxx = sum(sum([tx] .* [x])) * spacing^2 * 1e-6 ; 
Dxy = sum(sum([ty] .* [x])) * spacing^2 * 1e-6 ;
Dyx = sum(sum([tx] .* [y])) * spacing^2 * 1e-6 ;
Dyy = sum(sum([ty] .* [y])) * spacing^2 * 1e-6 ;
%=========================================================


[a_sym, lambda, theta0] = rotate1([Dxx Dxy; Dyx Dyy]);


% That's wrong... probably...its right RS
if abs(lambda(1,1)) > abs(lambda(2,2)), theta = -theta0;
else theta = pi/4 - theta0;
end;

a_tractions = tan(theta);
a_cuts = -1 / tan(theta);

Trace_moment = Dxx + Dyy;

Uecm = 0.5 * sum(sum([tx(cell) ty(cell)] .* [ux(cell) uy(cell)])) * spacing^2 * 1e-6;%1e-6(in fttc_v6)

% crop again

xx =x((N/4+1):(N/4*3),(N/4+1):(N/4*3)) ; %cropping data for traction.dat
yy =y((N/4+1):(N/4*3),(N/4+1):(N/4*3)) ; 
txx =tx((N/4+1):(N/4*3),(N/4+1):(N/4*3)) ; 
tyy =ty((N/4+1):(N/4*3),(N/4+1):(N/4*3)) ; 


%{
%xavi gives
ctx = tx(N/4+1:N/4+N/2,N/4+1:N/4+N/2);
cty = ty(N/4+1:N/4+N/2,N/4+1:N/4+N/2);
%}

if (strcmpi(CalcRot,'Yes')) == 1


%==================================================================
% calc rotation moment 
%==================================================================
nXPts = size(txx,1);
BW = imread([pathname 'croppeddata','/', 'domain', num2str(k), '.tif'],'tiff');
% reshape the domain map to the traction grid size
%BW01 = reshape(imresize(BW,[nXPts nXPts])*1,nXPts*nXPts,1);

BW02 =  imresize(BW,[nXPts nXPts]) ; 
txx(find(BW02==0)) =0; tyy(find(BW02==0)) =0;txx = txx*1.E12; tyy = tyy*1.E12;
txx = txx - mean2(txx); tyy = tyy - mean2(tyy); %txx = txx*1.E-12; tyy = tyy*1.E-12;
[cx, cy] = ait_centroid(BW02) ;  %center of mass
nzero = find(BW02~=0)   ; Nnz = size(nzero,1) ;
%cxx = (cx-1)/(nXPts-1) * (max2(xx) - min2(xx)) + min2(xx) ;  % convert center of mass coordi (pixel) to real coordi
%cyy = (cy-1)/(nXPts-1) * (max2(yy) - min2(yy)) + min2(yy) ;
cxx = (cx-1)/(nXPts-1) * (max2(xx) - min2(xx)) + min2(xx) ;  % convert center of mass coordi (pixel) to real coordi
cyy = (cy-1)/(nXPts-1) * (max2(yy) - min2(yy)) + min2(yy) ;
xx_cell = xx(nzero) - cxx ; yy_cell = yy(nzero) - cyy ; 
txx_cell = txx(nzero) ; tyy_cell = tyy(nzero) ; 
coordi = [ xx_cell  yy_cell yy_cell*0]; 
trct = [ txx_cell  tyy_cell tyy_cell*0] ; 
momt_r = cross(coordi, trct) ; tot_momt = sum( momt_r(:,3)) 
[ trct_ang  trct_rho ] = cart2pol(coordi(:,1), coordi(:,2)) ; %trct_rho_sum = sum(ones(Nnz,1)./trct_rho);
[trctx     trcty] = pol2cart( trct_ang+pi/2 , ones(Nnz,1)./trct_rho*tot_momt/Nnz) ; 
txx(nzero) = txx(nzero) - trctx/1. ; tyy(nzero) = tyy(nzero) - trcty/1. ;  
%txx = txx*1.E12; tyy = tyy*1.E12;
txx = txx - mean2(txx); tyy = tyy - mean2(tyy); txx = txx*1.E-12; tyy = tyy*1.E-12;
%mean2(txx)
%mean2(tyy)
%==================================================================
end


%save constrained tractions
tractions_crop = [reshape(xx,size(xx,1)*size(xx,2),1)/PixelSize reshape(yy,size(xx,1)*size(xx,2),1)/PixelSize reshape(txx,size(xx,1)*size(xx,2),1)*1.E12 reshape(tyy,size(xx,1)*size(xx,2),1)*1.E12];
%tractions_crop = [reshape(cx,size(cx,1)*size(cx,2),1) reshape(cy,size(cx,1)*size(cx,2),1) reshape(ctx,size(cx,1)*size(cx,2),1)*1.E12 reshape(cty,size(cx,1)*size(cx,2),1)*1.E12];
%save([coreDir 'Tractions/traction.dat'],'tractions','-ASCII'); 
save([pathname 'Tractions','/', 'Time',num2str(k),'/', 'traction','.dat'],'tractions_crop','-ASCII'); 



%====================================================================================
% FINAL RESULT OF CONSTRAINED METHOD

rmsTraction  = rmst_iterative*(1e12); % RMS tractions (Pa)
orientation  = theta0*180/pi+41.58238; % Orientation principale tractions ()(offset by 41)
netMoment    = -Trace_moment * (1e12); % Net moment
strainEnergy = Uecm * (1e12); % Total strain Energy

disp('rms Traction=');
disp(rmsTraction);
disp('Net moment=');
disp(netMoment);
disp('strain energy=');
disp(strainEnergy);
disp('orientation=');
disp(orientation);
